import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import Utilities.mccdaq_operations as mo
import threading 

board_num, low_chan, high_chan = 0, 0, 0
ai_range = mo.chan_range('bipolar_10')

label_x, label_y = 'Time (ms)', 'Voltage (V)'

root = gc.create_window(title='Digital Oscilloscope',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_trig = gc.trigger_control(control_box)

ax, canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

def acquire_waveform():

    num, samp_freq = gc.get_dig_entries(var_num,
                                        var_samp_freq)
    edge_option = gc.get_edge_option(var_trig)

    num_points, rate = num, int(samp_freq)

    mo.config_digital_triggering(board_num, edge_option)

    memhandle, ctypes_array = mo.create_buffer(num_points)

    t = wc.create_time_data(num, samp_freq)

    while btn.cget('text') == 'Stop':
        
        y = mo.read_waveform(board_num, low_chan, high_chan,
                             num_points, rate, ai_range,
                             memhandle, ctypes_array)

        pc.update_plot(ax, canvas, 1000*t, y,
                       label_x, label_y, marker='o-')

    mo.free_buffer(memhandle)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_waveform)
    t.start()

    return

btn = gc.action_button(control_box, label='Start',
                       action=toggle)

root.mainloop()

